	function linremez(ncoe,idelay,nbands,edge,des,wt,ngrid)
	
	% Prepares initial extreme points for forcing routine.
	% Calls forcing routine and use results to locate new extreme points.
	% Uses these new extreme points as new initial extreme points for next
	% forcing round.
	% Returns when all extreme points are true extreme points and when forcing
	% routine has forced those points to have same absolute error.
	
	% <---------------------------------------------------------------<< DH <<<
	% SYM_WDF.m -> linremez.m -> newgrid.m
	%                          -> iextnew.m
	%                          -> forcing.m -> forcehelp.m -> phas.m
	%                          -> phas.m
	%                          -> removeiext.m
	%            -> factors.m
	% <---------------------------------------------------------------<< DH <<<
	% Global variables OME, OMEXOME and BETA are used to transfer necessary
	% information between these four functions: linremez, forcehelp, phas and
	% factors
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-10
	% 	Modified by: 	LW, 2019-03-04
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	tapio.saramaki@tut.fi
	
	
	% <--- edited  May-14-2008 with MATLAB R2006a --------------------<< DH <<<
	% lots of comments added
	
	global PHA OME OMEXOME BETA     % These global variables are used to pass
	% data between linremez, forcehelp, phas and factors functions.
	PHA = []; OME = []; OMEXOME = []; BETA = [];
	
	itrmax = 69;  % At original fortran routine this value was 30, but in some
	% designs that value is too low. I have used value up to 200.
	nz = ncoe+1;  % Number of extremal points. There is always one more than 
	% number of coefficients.	
	
	ndev = 1;     % Starting/default value for that extra extreme point. Usually
	% If forcing part of the routine fails, algorithm changes this value and
	% tries again and keeps trying until all of them are used once, if they all 
	% fail then new set of initial values are brought in.	
	dev = 1E-6;   % Initial phase deviation, starting value for extra extreme 
	% point error. This error value is increased in each iteration round until
	% it becomes same as error in those other extreme points.	
	
	consndevvector = zeros(1,ncoe+1); % consumed ndev vector, keeps track which
	% ndev values are already used. When all ndev values are used as extra 
	% extreme points, this vector is reseted and new initial values are used.	
	niter = 0;    % counter for number of iteration rounds, after 69 rounds
	% algorithm gives up	
	
	combinationcounter = 1;   % Algorithm prepares 5-25 different initial values 
	% how extreme points are divided to for each band. This keeps track which 
	% we are used at the moment. Usually one of first three gives solution.	
	
	iextconsecutivecounter = 0;   % Main way to control algorithm if forcing part
	% gives us something unexpected. That is two exreme points that are in 
	% consecutive grid points. This means that forcing part has failed someway.
	% due to poor initial values. Algorithm recovers from these abnormalities
	% and tries again with different input.	
	% There are several ways to give a little different initial values. We can
	% change ndev, so we use different extreme point as that extra extreme
	% point
	% We can go back little more and bring in whole new set of initials values.
	% We can almost start over and give algorithm a whole new set of initial
	% value combinations, i.e. we divide extreme points differently to each
	% band. If all these tricks fails, user need to restart and give more grid
	% points or manually give better inital values.
	% For hard cases it is really hard to find good initial values.
	% For those cases algorithm tries even 50 to 100 different initial values
	% until one of those are good enough and gives finally solution.	
	% We need to draw a line somewhere how long algorithm tries to find
	% solution	
	% This trial and error is still quite fast (couple seconds), so its worth
	% to try until we give turn to user and he can try to continue with
	% manually entered values.	
	% User can skip these and give good initial values (if known) right away
	% manually. But this requires code editing, so its kind of akward.	
	
	iextnewc = 0; % This counter is increased every time changes are made to
	% initial values, when this goes over ten, we give up with current
	% extreme point combination and bring brand new in.
	
	iwtc = 0; % In two band cases, it easier to find solution if we change
	% gradually weight until final weight is achieved. We do this in ten steps.
	% This is only needed when there is huge difference in weights, 
	% like [1 10000]. This iwtc is just a counter for those ten steps.	
	newinitialscounter = 0;   % Added just to count how many times initials are
	% changed, only debug purpose.	
	% <--- set up equally spaced dense grid --------------------------<< DH <<<
	[iedge,ides,iwt,igrid] = newgrid(edge,des,wt,ngrid);	
	if (idelay ~= 0);	% Different desired values
		ides = ides-idelay*igrid*2*pi;
	end 
	% for approximately linear build (2nd branch is pure delay)	
	if (length(wt) == length(igrid))  % User has given different weigh for each
		iwt = wt;                     % grid point, so this weight-vector
	end                             % overrides default one weight per band

	if (nbands == 2 & idelay == 0);iwtmax = iwt;iwt = ones(1,length(iwtmax));end
	% For two band design it is possible to change weight after right extreme
	% points are already found. Changing weight keeps those extreme points at
	% same place. This trick is done to help algorithm (less chance to
	% overflow) to find solution when there is huge weight difference between
	% bands. Its very fast to recalculate new error values when extreme points
	% are already found, so we can do thise in several steps, here ten steps
	% are used.	

	if (length(des) == length(igrid))     % For those phase equalization designs
		ides = des;      % desired value is given for each grip point separately
	end % This part of algorithm NOT done yet!
	% <--- Bring in first set of extreme points combination as -------<< DH <<<
	% <--- initial values. -------------------------------------------<< DH <<<
	[mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,combinationcounter);	
	if (err == 9);
		fprintf('\n\n No more initial extreme points combinations !!!');
		fprintf('\n Solution is NOT valid. Just printing result from last');
		fprintf('\n forcing round.\n\n');
		fprintf('\nAlgorithm tried %2.0f ',newinitialscounter+1');
		fprintf('different intial values.\n');
		return; % EXIT couldn't find solution
	end; % We need to end it at some point, user can still give manually
	% initial values and found solution.	
	%kk = -kk     % Uncomment this line when designing Hilbert transformers.
	% kk is a sign of first extreme point, for Hilbert its always negative. 
	iextold = iext;   % makes backup from current extreme values, old values are
	% used later to recover if forcing part fails.
	iext = [iext ngrid+1];
	solutionfound = 0;    % one condition to break optimization loop
	iextgood = [];        % One way to make sure that solution is found is by
	% comparing current extreme points locations to those from previous round.
	% If values are equal then its likely that solution is found. This is one
	% of subtest, in addition error values need to be same in those points.	
	while (solutionfound == 0)
		iextnochange = 0;  % testing result while comparing iext values for two 
		% consecutive rounds. 
		solutionfound2 = 0;    % This is turned to one when error in extra extreme
		% point is very close to error in other extreme
		% points. One condition to turn  solutionfound to 1
		niter = niter+1;       % counter for number of iteration rounds, max 69
		if (niter > itrmax) % solution cannot be found by using current initial
			disp('test6')  % values   test6 message, for debugging only
			combinationcounter = combinationcounter+1;
			% New set of extreme points combination are brought in as new initial
			% values.
			[mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,...
			combinationcounter); % new initial values are needed
			if (err == 9);
				fprintf('\n\n No more initial extreme points combinations !!!');
				fprintf('\n Solution is NOT valid. Result has only debugging');
				fprintf('\n use or a good starting point if you decide to'); 
				fprintf('\n manually alter some code lines.');
				fprintf('\nAlgorithm tried %2.0f ',newinitialscounter+1');
				fprintf('different intial values.\n');
				return; % EXIT couldn't find solution 
			end;  
			dev = 1E-6;niter = 1;  % reseting to starting values 
			iext = [iext ngrid+1];
		end
		% <--- calculate angular frequencies at extrema ---------------<< DH <<<
		x(1:nz) = 2*pi*igrid(iext(1:nz)); 
		%w = x; % This is original line, but next line replace this at the moment.
		w = [x nbands iedge igrid]; % nbands,iedge and igrid were added for
		% plotting purpose only	
		% <--- find number of extrema in each band --------------------<< DH <<<
		%ndev = input('give new ndev: '); % Uncomment this line to manually track
		% down optimal solution.
		[dev,err] = forcing(dev,ncoe,iext,ides,iwt,w,ndev,kk);
		% err is not handled at the moment
		PHA(1:ngrid) = 0;	
		%==================================================
		% <--- main iteration loop ---------------------------------------<< DH <<<
		iext = [];errorvalues = [];magn = [];
		kk2 = kk;      % to check that consecutive extreme points have different sign
		for i = 1:nbands
			for gp = iedge(2*i-1):iedge(2*i) % going through every grid point at i:th
				% band
				a2(gp) = phas(2*pi*igrid(gp),ides(gp)); % phase values at those grid
				% points
			end
			a3 = a2(iedge(2*i-1):iedge(2*i))-ides(iedge(2*i-1):iedge(2*i)); % desired
			% values are subtracted
			a1 = a3.*iwt(iedge(2*i-1):iedge(2*i)); % multiplied by weight vector, now
			% error vector is ready and we can start to locate extreme points.	
			% first point at first band cannot be extreme point.
			if (i ~= 1);
				iext = [iext 1+iedge(2*i-1)-1]; kk2 = -kk2; magn = [magn a1(1)];
			end;
			ee = 2;
			while (ee < length(a1)) % going through every error in error vector
				% max or min 
				if ( (a1(ee) > a1(ee-1) & a1(ee)>  a1(ee+1)) | ( a1(ee) < a1(ee-1) ...
					& a1(ee) < a1(ee+1)) )
					iext = [iext ee+iedge(2*i-1)-1];magn = [magn a1(ee)];
					% if current value is bigger than previous value AND if its also
					% bigger than next value OR if current value is smaller than previous
					% one AND it is also smaller than next value THEN new extreme point
					% is found and its location is added to extreme points vector
				end
				ee = ee+1;
			end
			if (i ~= nbands)
				iext = [iext length(a3)+iedge(2*i-1)-1];kk2 = -kk2;magn = [magn a1(end)];
			end 
			% last point at each band is extreme point except at last band
			if (i == 1);
				lmerk = sign(a3(end));
			end    % sign of last extreme point
			errorvalues = [errorvalues a3];        % at first band
		end
		samesign = 0; % reseting 'if two consecutive extreme have same sign' -value
		for i = 1:length(iext)-1   % testing if consecutive ext points have same sign
			if ( sign(errorvalues(iext(i))) == sign(errorvalues(iext(i+1))))
				samesign = samesign+1;
			end
		end
		if (length(iext)>ncoe+1 & samesign>0) % There are too many extreme
			% points. Forcing part of algorithm needs exactly ncoe+1 extreme points
			% as input so one or more need to be removed before calling next forcing
			% round
			[iext,magn] = removeiext(iext,magn); % if there are two consecutive ext
		end                                   % points with same sign remove
		% smaller one
		iextconsecutive = 0;     % Forcing part of algorithm sometimes gives extreme
		% points that are in consecutive grid points. Forcing part is then clearly
		% failed somehow due to too few grid points or bad initial values. We need
		% to recover from that and try to give better values for next forcing
		% round.
		cons1 = [];growpart = 0;
		for i = 1:length(iext)-1 % testing if there are consecutive extreme points
			if ( iext(i) == iext(i+1)-1 & sum(iext(i) == iedge) == 0 & ...
				sum(iext(i+1) == iedge) == 0 )
				iextconsecutive = iextconsecutive+1;
				cons1(iextconsecutive) = iext(i);   % Consecutive extreme points that
			end                                   % are not band edges are found.
		end
		if (iextconsecutive == 0)     % When forcing part fails and gives a way too
			% many and/or consecutive extreme points. Those values are totally useless,
			% and we cannot continue/recover by using those. So we made (in case)
			% restore points after each succesfull forcing in order to recover when
			% shit hit the fan. We modify those previous values and try again. At this
			% point is like shooting fish at barrel, we will catch it if barrel is not
			% empty
			iextconsecutivecounter = 0;
		else
			iextconsecutivecounter = iextconsecutivecounter+1;
		end % making restore point if everything fails
	
		% Next lines are for special filters only, and those need to take care
		% a little differently
		
		%iext = [1 iext];         % remove comment for Hilbert transformer design
		% first point is always extreme point for Hilbert
		%iext = [1 iext 1000];    % for Hilbert if order is odd
		% then last and first are ext points
		
		% Algorithm need to behave slightly differently for Hilbert filters. Those
		% can be designed, but it's not done properly yet, so some code editing
		% need to be done beforehand.
		% Not much, just remove some comment (%) chars from some code lines
		% I have been too lazy to do those automatically, or actually this code
		% long enough at the moment. Better do much shorter version for those
		% special designs.
		if (idelay ~= 0 & fix(idelay) ~= idelay)   % this is true only for arbitrary
			iext = [iext ngrid];                   % non-integer delay design
		end     % Usually last grid point cannot be extreme point but for
		% this kind of design it is alwasy, so its added here.
		iextabs = abs(errorvalues(iext)).*iwt(iext); % absolute values of extreme 
		% points are stored. Later used to reject one or more extreme points.
		if (iextconsecutivecounter == 0 & length(iext) == ncoe+3) % two extra extreme
			% need to be removed from the list to get right amount for next forcing
			% round
			[m,i] = min(iextabs);
			if (i == 1);iext = iext(i+1:end); % 1st one is the smallest and it is
				iextabs = iextabs(i+1:end); % removed
			end                                                 
			if (i == length(iext));
				iext = iext(1:i-1);iextabs = iextabs(1:i-1);
			end
			% last one is the smallest and it is removed
			[m,i] = min(iextabs);
			if (i == 1);
				iext = iext(i+1:end);iextabs = iextabs(i+1:end);
			end
			% First one is removed 2nd time
			if (i == length(iext));
				iext = iext(1:i-1);iextabs = iextabs(1:i-1);
			end
			% Last one is removed 2nd time
		end	
		if (iextconsecutivecounter == 0 & length(iext)>ncoe+1) % too many extreme
			% points but those are not consecutive extreme points, so they might be
			% valid ones
			iextnewc = iextnewc+1; % We can tolerate some amount of missbehaving from
			% forcing part, because some optimal solutions actually have one or
			% more (algorithm can handle only one extra at the moment, while 
			% debugging I have seen cases were there was three valid extra extrem 
			% points) extra extreme points. We use counter to keep track of these,
			% if these happens too often/too many times our threshold point/value
			% is reached and we need to do some counter action. We quit using these
			% 'too bad' inital values and bring better (hopefully) candidates in and
			% use those brand new as initals. If they are 'bad' also, we reset again
			% and bring in next ones. We do this rince and repeat until we found 
			% solution or when we run out those candidates. Then its time to give
			% up totally. Then that design cannot be design with this algorithm or
			% or we need to give manually very good starting values to get solution.
			
			[maxvalue,maxin] = max(abs(errorvalues(iext)));
			for ii = 1:length(mgrid)
				maxvect(ii) = (iext(maxin) >= iedge(2*ii-1) & iext(maxin) <= iedge(2*ii));
				% only points within bandedges are valid
			end
			if (maxvect(end) == 1) % biggest extreme point is in last band
				iextold = iext;
				iext = iext(2:end);% removing 1st extreme point, because the biggest 
				kk = -kk;          % one is at last band. Sign of 1st EP is changed.
			else
				iext = iext(1:end-1); % last extreme point wasn't biggest so it gets removed
				iextold = iext;
			end
			% Checking if optimal solution is found even if there still are some
			% extra extreme points. There might be extra extreme point in optimal
			% solution in some cases.
			[maxiextabs,iextm1] = max(iextabs); % locating max value
			iextabs2 = [iextabs(1:iextm1-1) iextabs(iextm1+1:end)]; % storing all but
			% highest value
			[miniextabs,iextm2] = min(iextabs2); % locating minimum value
			iextabs3 = [iextabs2(1:iextm2-1) iextabs2(iextm2+1:end)]; % storing all
			% min value
			if (maxiextabs > 0.9*mean(iextabs3) & ...
				maxiextabs < 1.1*mean(iextabs3)); % testing if highest value is
				% near other extreme points maximum values, or withing +/- 10%
				solutionfound = 1;
				fprintf('largest ext / average ext : %3.14f \n',...
				maxiextabs/mean(iextabs3)); % printing out how close max and 
				% average value of others are. One way to control that solution
				% is valid.
			end
			if (solutionfound == 1); % Previous printing gives user some info if this
				% solution is good or not. User can continue couple of rounds and
				% compare those error values. Time to quit when error is at minimum.
				solutionfound = input('quit optimization 0 = no 1 = yes :');
				% In these cases, user decides when solution is valid
			end
		end
		if (iextconsecutivecounter == 1 | length(iext) < ncoe+1) 
			% consecutive extreme points or too few extreme points
			iextnewc = iextnewc+.025;consndevvector(ndev) = consndevvector(ndev)+1;
			% minor addition to reset counter. Current ndev is marked to 'used one'
			newinitialscounter = newinitialscounter+1;
			ndev = ndev+1; % changing to next ndev value, so new extra extreme point
			% location is used for next forcing round.
			if (ndev>ncoe+1);% all ndev values were tried, changing 
				ndev = 1;
			end 
			% back to 1 or default value.
			iext = iextold;   % cannot use current values for next forcing round. We
			% need to go back and use backup values from previous 'succesful' round
		end
	
		%pros1 = [.98 .82 .45 .25 .1]; Another way to make initial values
		pros1 = [.95 .85 .75 .65 .4]; 
		% We can't use random values as initials. If and when algorithm finds
		% solution, we need to find that later on too. We can't trust for good
		% luck.
		% So we prepare five different set of initial values. So algorithm can
		% change to next one if previous one fails.
		% .95 means that we generate those initials using 95% grid points, starting
		% from band edges. So almost all grid points are valid for this 1st guess.
		% .4 means that we pick all those initial values very near to band edges,
		% only 40% of grid points are valid now and we pick those values among
		% them. Solution is quite near of these when transition band is very
		% narrow.
		% Those b-vectors below are just to make better quality quess. So more
		% values near band edges get chosen and density is not so high when going
		% further.
		% So they are not equallyspaced, quite opposite and goal is to mimic
		% optimal values
		% All those lines are just to make good but still quite different sets of
		% initial values. 
		
		if (iextconsecutivecounter == 2) % we use new set of initial values, so 
			% previous values are failed.
			c = 1.4;pros = pros1(1); % .95 so using almost whole band area
			b = [0.1 1 1+c 1+c+c^2 1+c+c^2+c^3 1+c+c^2+c^3+c^4 1+c+c^2+c^3+c^4+c^5];
			b2 = 1+c+c^2+c^3+c^4+c^5;
			b = [b b2+c^6 b2+c^6+c^7 b2+c^6+c^7+c^8 b2+c^6+c^7+c^8+c^9 ...
			b2+c^6+c^7+c^8+c^9+c^10];
			b3 = b2+c^6+c^7+c^8+c^9+c^10;
			b = [b b3+c^11 b3+c^11+c^12 b3+c^11+c^12+c^13 b3+c^11+c^12+c^13+c^14];
			b4 = b3+c^11+c^12+c^13+c^14;
			b = [b b4+c^15 b4+c^15+c^16 b4+c^15+c^16+c^17 b4+c^15+c^16+c^17+c^18];
			for i = 1:nbands
				a = (iedge(2*i)*pros-iedge(2*i-1))/b(mgrid(i));
				if (i == 1);
					iext = fix(-1*b(1:mgrid(i))*a)+iedge(2*i);iext = fliplr(iext);
				else
					iext = [iext fix(b(1:mgrid(i))*a)+iedge(2*i-1)];
				end
			end
			newinitialscounter = newinitialscounter+1;iextnewc = iextnewc+1;
		end
		if (iextconsecutivecounter == 3) % Another failure with previous values.
			% Time to set new starting values for extreme point starting locations.
			% This time selected grid points are little closer to band edges, but
			% still almost all band area is used.
			c = 1.4;pros = pros1(2); %.85; Almost all band area are covered
			b = [0.1 1 1+c 1+c+c^2 1+c+c^2+c^3 1+c+c^2+c^3+c^4 1+c+c^2+c^3+c^4+c^5];
			b2 = 1+c+c^2+c^3+c^4+c^5;
			b = [b b2+c^6 b2+c^6+c^7 b2+c^6+c^7+c^8 b2+c^6+c^7+c^8+c^9 ...
			b2+c^6+c^7+c^8+c^9+c^10];
			b3 = b2+c^6+c^7+c^8+c^9+c^10;
			b = [b b3+c^11 b3+c^11+c^12 b3+c^11+c^12+c^13 b3+c^11+c^12+c^13+c^14];
			b4 = b3+c^11+c^12+c^13+c^14;
			b = [b b4+c^15 b4+c^15+c^16 b4+c^15+c^16+c^17 b4+c^15+c^16+c^17+c^18];
			for i = 1:nbands
				a = (iedge(2*i)*pros-iedge(2*i-1))/b(mgrid(i));
				if (i == 1);
					iext = fix(-1*b(1:mgrid(i))*a)+iedge(2*i);iext = fliplr(iext);
				else
					iext = [iext fix(b(1:mgrid(i))*a)+iedge(2*i-1)];
				end
			end
			newinitialscounter = newinitialscounter+1;iextnewc = iextnewc+1;
		end
		if (iextconsecutivecounter == 4) % Another attempt, again slightly different
			% starting values are generated. This time all values are picked up
			% quite near band edges.
			c = 1.4;pros = pros1(3); %.75 initial exp are picked quite close to edge
			b = [0.1 1 1+c 1+c+c^2 1+c+c^2+c^3 1+c+c^2+c^3+c^4 1+c+c^2+c^3+c^4+c^5];
			b2 = 1+c+c^2+c^3+c^4+c^5;
			b = [b b2+c^6 b2+c^6+c^7 b2+c^6+c^7+c^8 b2+c^6+c^7+c^8+c^9 ...
			b2+c^6+c^7+c^8+c^9+c^10];
			b3 = b2+c^6+c^7+c^8+c^9+c^10;
			b = [b b3+c^11 b3+c^11+c^12 b3+c^11+c^12+c^13 b3+c^11+c^12+c^13+c^14];
			b4 = b3+c^11+c^12+c^13+c^14;
			b = [b b4+c^15 b4+c^15+c^16 b4+c^15+c^16+c^17 b4+c^15+c^16+c^17+c^18];
			for i = 1:nbands
				a = (iedge(2*i)*pros-iedge(2*i-1))/b(mgrid(i));
				if (i == 1);
					iext = fix(-1*b(1:mgrid(i))*a)+iedge(2*i);iext = fliplr(iext);
				else
					iext = [iext fix(b(1:mgrid(i))*a)+iedge(2*i-1)];
				end
			end
			newinitialscounter = newinitialscounter+1;iextnewc = iextnewc+1;
		end
		if (iextconsecutivecounter == 5) % 2nd last attempt with current initial
			% combination. And again chosen points are little closer to band edges.
			c = 1.4;pros = pros1(4); %.65  almost all near band edges
			b = [0.1 1 1+c 1+c+c^2 1+c+c^2+c^3 1+c+c^2+c^3+c^4 1+c+c^2+c^3+c^4+c^5];
			b2 = 1+c+c^2+c^3+c^4+c^5;
			b = [b b2+c^6 b2+c^6+c^7 b2+c^6+c^7+c^8 b2+c^6+c^7+c^8+c^9 ...
			b2+c^6+c^7+c^8+c^9+c^10];
			b3 = b2+c^6+c^7+c^8+c^9+c^10;
			b = [b b3+c^11 b3+c^11+c^12 b3+c^11+c^12+c^13 b3+c^11+c^12+c^13+c^14];
			b4 = b3+c^11+c^12+c^13+c^14;
			b = [b b4+c^15 b4+c^15+c^16 b4+c^15+c^16+c^17 b4+c^15+c^16+c^17+c^18];
			for i = 1:nbands
				a = (iedge(2*i)*pros-iedge(2*i-1))/b(mgrid(i));
				if (i == 1);
					iext = fix(-1*b(1:mgrid(i))*a)+iedge(2*i);iext = fliplr(iext);
				else
					iext = [iext fix(b(1:mgrid(i))*a)+iedge(2*i-1)];
				end
			end
			newinitialscounter = newinitialscounter+1;iextnewc = iextnewc+1;
		end
		if (iextconsecutivecounter == 6) % Finally last attempt. Now all starting
			% values for extra extreme point locations are selected from very narrow
			% set of grid points. All located near band edges. If this fails too
			% then we go back to 1st set, but we change extreme points combination
			% too. So whole new initials for next run.
			c = 1.4;pros = pros1(5); %.4 Initials are picked very close to band edges.
			b = [0.1 1 1+c 1+c+c^2 1+c+c^2+c^3 1+c+c^2+c^3+c^4 1+c+c^2+c^3+c^4+c^5];
			b2 = 1+c+c^2+c^3+c^4+c^5;
			b = [b b2+c^6 b2+c^6+c^7 b2+c^6+c^7+c^8 b2+c^6+c^7+c^8+c^9 ...
			b2+c^6+c^7+c^8+c^9+c^10];
			b3 = b2+c^6+c^7+c^8+c^9+c^10;
			b = [b b3+c^11 b3+c^11+c^12 b3+c^11+c^12+c^13 b3+c^11+c^12+c^13+c^14];
			b4 = b3+c^11+c^12+c^13+c^14;
			b = [b b4+c^15 b4+c^15+c^16 b4+c^15+c^16+c^17 b4+c^15+c^16+c^17+c^18];
			for i = 1:nbands
				a = ((iedge(2*i)-iedge(2*i-1))*pros)/b(mgrid(i));
				if (i == 1);
					iext = fix(-1*b(1:mgrid(i))*a)+iedge(2*i);iext = fliplr(iext);
				else
					iext = [iext fix(b(1:mgrid(i))*a)+iedge(2*i-1)];
				end
			end
			newinitialscounter = newinitialscounter+1;iextnewc = iextnewc+1;
		end
	
		% All previous attempts are failed. Time to change extreme points
		% combination. We prepared (in case) about 20 different ones at initial
		% stage of algorithm. Usually one of first three gives solution. But those
		% four band or more required more options. Hard to generate good starting
		% values right away for those, so plenty of trial and error needed.
		if (iextconsecutivecounter == 7 | (iextnewc == 10 & ...
			iextconsecutivecounter > 0) | iextnewc > 12)   % time to change
			if (nbands == 2 & idelay == 0)                     % initials combination
				newinitialscounter = newinitialscounter+1;
				ngrid = ngrid+1000;    % When designing 2 band filters with very
				% narrow transition band lots of grid points
				% are needed, algorithm automatically increased
				% initial value in 1000 grid points steps.
				% No upper limit at the moment, user have to
				% cancel routine if solution not found.
				fprintf('\n Increasing number of grid points ,now %4.0f ',ngrid);
				fprintf(' grid points.\n');  % Some information to user, so he/she
				% can cancel algorithm when needed
				dev = 1E-6;                    % initial phase deviation
				niter = 0;combinationcounter = 1;iextconsecutivecounter = 0;iextnewc = 0;
				
				% <--- setting up new grid density ------------------------<< DH <<<
				[iedge,ides,iwt,igrid] = newgrid(edge,des,wt,ngrid);
				if (idelay ~= 0)
					ides = ides-idelay*igrid*2*pi;  % added 2*edge(end) for delay
				end                                 % optimization
				% Bring in new set of extreme points combination as initials.
				disp('test7')
				[mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,...
				combinationcounter);
				if (err == 9);
					fprintf('\n\n No more initial extreme points combinations !!!')
					fprintf('\n Solution is not valid. Just printing result from ')
					fprintf('last forcing roung.\n\n')
					fprintf('\nAlgorithm tried %2.0f ',newinitialscounter+1');
					fprintf('different intial values.\n');
					return; % EXIT couldn't find solution
				end
				%kk = -kk % for Hilbert need to uncomment this line
				iextold = iext;solutionfound = 0;iextgood = [];
			elseif (idelay ~= 0)
				if(sum(consndevvector) == ncoe+1)
					combinationcounter = combinationcounter+1;consndevvector(:) = 0;
					newinitialscounter = newinitialscounter+1;
					% ndev vector to zero
					% Bring in new set of extreme points combination as initials.
					[mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,...
					combinationcounter);
					if (err == 9);
						fprintf('\n\nNo more initial extreme points combinations!')
						fprintf('\nSolution is not valid. Just printing result ')
						fprintf('from \nlast forcing round.\n\n');
						fprintf('\nAlgorithm tried %2.0f ',newinitialscounter+1');
						fprintf('different intial values.\n');
						return; % EXIT couldn't find solution
					end
					iextnewc = 0;iextconsecutivecounter = 0;iextgood = [];
				else
					consndevvector(ndev) = consndevvector(ndev)+1;
					ndev = ndev+1;
					if (ndev > ncoe+1); ndev = 1;end % all ndev values were tried
						iextnewc = 0;
					end
				else
					combinationcounter = combinationcounter+1;consndevvector(:) = 0;
					newinitialscounter = newinitialscounter+1;
					[mgrid,iext,kk,err] = iextnew(ncoe,nbands,des,iedge,...
					combinationcounter);
					if (err == 9);
						fprintf('\n\nNo more initial extreme points combinations !!!')
						fprintf('\nSolution is not valid. Just printing result from')
						fprintf('\nlast forcing round.\n\n');
						fprintf('\nAlgorithm tried %2.0f ',newinitialscounter+1');
						fprintf('different intial values.\n');
						return; % EXIT couldn't find solution
					end
					iextnewc = 0;iextconsecutivecounter = 0;iextgood = [];
				end
			end
			if (iextconsecutivecounter == 0 & niter > 3 & isempty(iextgood) == 0)
				iextnochange = 0;
				if (sum(iext(1:nz) == iextgood(1:nz)) == nz)     % testing if first nz
					iextnochange = 1;                            % values are the same
					iextnewc = iextnewc+1;        % to prevent infinite loop after 10
				end                               % new combinations
				[maxiextabs,iextm1] = max(iextabs);
				iextabs2 = [iextabs(1:iextm1-1) iextabs(iextm1+1:end)];
				[miniextabs,iextm2] = min(iextabs2);
				iextabs3 = [iextabs2(1:iextm2-1) iextabs2(iextm2+1:end)];
				% testing if extreme point values are close to each other (equiripple)
				% solution is found if they are close enough.
				if (maxiextabs>.999*mean(iextabs3) & maxiextabs < 1.001*mean(iextabs3))
					solutionfound2 = 1;
				end
				if (lmerk == -1 & iextnochange == 1 & solutionfound2 == 1);solutionfound = 1;
					% solution is found.
					%				fprintf('\nExtreme points locations remain the same and their')
					%				fprintf(' values\nare almost same (largest ext')
					%				fprintf('/average ext =  %2.14f) \n',maxiextabs/mean(iextabs3))
				end
			end
			if (iextconsecutive == 0);
				iextgood = iext;
			end
			iext = [iext ngrid+1];
			for ii = 1:length(mgrid)
				mgrid2(ii) = length(iext(iext >= iedge(2*ii-1) & iext <= iedge(2*ii)));
			end
			if (isequal(mgrid,mgrid2) == 0)   % mgrid2 is new candidate for mgrid
				[c,d] = min(mgrid2);          % minimum number of ext points for each 
				if (c == 0)                   % band is one
					iext = iextold2;          % zero value not allowd, candidate not valid
				else                          % use previous round backup instead
					mgrid = mgrid2;
				end
				if (mod(mgrid(1),2) ~= 0) % Last iext at first band is always negative.
					kk = -1;                % If there are even number of ext points at
				else                     % 1st band then the sign of first iext point
					kk = 1;                 % is positive. If there are odd number of iext
				end                      % points at 1st band then sign of first iext
			end                          % point is negative.
			iextold2 = iext;	
			if (solutionfound == 1 & nbands == 2 & idelay == 0) % for 2-band filter it is 
				% possible to change weight after optimization
				n = 10; % This weight change is done gradually to help forcing rounds to
				% find solution. Weight change is done here in ten steps.
				solutionfound = 0;
				iwtc = iwtc+1;
				if (iwtc == n+1 | isequal(iwtmax,iwt) == 1);solutionfound = 1;
			else
				if iwtc == 1
					fprintf('\nChanging weight in ten steps. Filter is optimized ')
					fprintf('after each weight change');
				end
				if (length(iwtmax) ~= length(iwt))
					iwtmax = [linspace(wt(1),wt(1),iedge(2))...
					linspace(wt(end),wt(end),iedge(4)+1-iedge(3))];
				end
				wt1 = ones(1,length(iwtmax));
				iwtm = [ones(n-1,1)*wt1+(0:n-2)'*(iwtmax-wt1)/(floor(n)-1);iwtmax];
				iwt = iwtm(iwtc,:);
			end
		end 	
	end %while
	i3 = 0;
	err = 0; 
	return
	
